/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;
import software.bernie.ars_nouveau.geckolib3.GeckoLib;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoCube;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoQuad;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoVertex;
import software.bernie.ars_nouveau.geckolib3.item.GeoArmorItem;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class ExtendedGeoEntityRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    protected final HumanoidModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_INNER = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
    protected final HumanoidModel<LivingEntity> DEFAULT_BIPED_ARMOR_MODEL_OUTER = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
    protected float widthScale;
    protected float heightScale;
    protected T currentEntityBeingRendered;
    private float currentPartialTicks;
    protected ResourceLocation textureForBone = null;
    protected final Queue<Tuple<GeoBone, ItemStack>> HEAD_QUEUE = new ArrayDeque<Tuple<GeoBone, ItemStack>>();
    protected static Map<ResourceLocation, Tuple<Integer, Integer>> TEXTURE_SIZE_CACHE = new HashMap<ResourceLocation, Tuple<Integer, Integer>>();
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    protected ExtendedGeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        this(renderManager, modelProvider, 1.0f, 1.0f, 0.0f);
    }

    protected ExtendedGeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider, float widthScale, float heightScale, float shadowSize) {
        super(renderManager, modelProvider);
        this.f_114477_ = shadowSize;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
    }

    protected void renderHeads(PoseStack stack, MultiBufferSource buffer, int packedLightIn) {
        while (!this.HEAD_QUEUE.isEmpty()) {
            Tuple<GeoBone, ItemStack> entry = this.HEAD_QUEUE.poll();
            GeoBone bone = (GeoBone)entry.m_14418_();
            ItemStack itemStack = (ItemStack)entry.m_14419_();
            stack.m_85836_();
            this.moveAndRotateMatrixToMatchBone(stack, bone);
            GameProfile skullOwnerProfile = null;
            if (itemStack.m_41782_()) {
                String s;
                CompoundTag compoundnbt = itemStack.m_41783_();
                if (compoundnbt.m_128425_("SkullOwner", 10)) {
                    skullOwnerProfile = NbtUtils.m_129228_((CompoundTag)compoundnbt.m_128469_("SkullOwner"));
                } else if (compoundnbt.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)(s = compoundnbt.m_128461_("SkullOwner")))) {
                    SkullBlockEntity.m_155738_((GameProfile)new GameProfile((UUID)null, s), p_172560_ -> compoundnbt.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)p_172560_)));
                }
            }
            float sx = 1.0f;
            float sy = 1.0f;
            float sz = 1.0f;
            try {
                GeoCube firstCube = bone.childCubes.get(0);
                if (firstCube != null) {
                    sx = firstCube.size.m_122239_() / 8.0f;
                    sy = firstCube.size.m_122260_() / 8.0f;
                    sz = firstCube.size.m_122269_() / 8.0f;
                }
            }
            catch (IndexOutOfBoundsException firstCube) {
                // empty catch block
            }
            stack.m_85841_(1.1875f * sx, 1.1875f * sy, 1.1875f * sz);
            stack.m_85837_(-0.5, 0.0, -0.5);
            SkullBlock.Type skullblock$type = ((AbstractSkullBlock)((BlockItem)itemStack.m_41720_()).m_40614_()).m_48754_();
            SkullModelBase skullmodelbase = (SkullModelBase)SkullBlockRenderer.m_173661_((EntityModelSet)Minecraft.m_91087_().m_167973_()).get(skullblock$type);
            RenderType rendertype = SkullBlockRenderer.m_112523_((SkullBlock.Type)skullblock$type, (GameProfile)skullOwnerProfile);
            SkullBlockRenderer.m_173663_((Direction)null, (float)0.0f, (float)0.0f, (PoseStack)stack, (MultiBufferSource)buffer, (int)packedLightIn, (SkullModelBase)skullmodelbase, (RenderType)rendertype);
            stack.m_85849_();
        }
    }

    @Override
    public void render(GeoModel model, T animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderHeads(matrixStackIn, renderTypeBuffer, packedLightIn);
    }

    @Override
    public ResourceLocation getTextureLocation(T entity) {
        return this.modelProvider.getTextureLocation(entity);
    }

    @Override
    public void renderLate(T animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        super.renderLate(animatable, stackIn, ticks, renderTypeBuffer, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
        this.currentEntityBeingRendered = animatable;
        this.currentPartialTicks = partialTicks;
    }

    protected abstract boolean isArmorBone(GeoBone var1);

    protected void moveAndRotateMatrixToMatchBone(PoseStack stack, GeoBone bone) {
        stack.m_85837_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(bone.getRotationX()));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(bone.getRotationY()));
        stack.m_85845_(Vector3f.f_122227_.m_122240_(bone.getRotationZ()));
    }

    protected void handleArmorRenderingForBone(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, ResourceLocation currentTexture) {
        ItemStack armorForBone = this.getArmorForBone(bone.getName(), this.currentEntityBeingRendered);
        EquipmentSlot boneSlot = this.getEquipmentSlotForArmorBone(bone.getName(), this.currentEntityBeingRendered);
        if (armorForBone != null && boneSlot != null) {
            if (armorForBone.m_41720_() instanceof ArmorItem && !(armorForBone.m_41720_() instanceof GeoArmorItem)) {
                ArmorItem armorItem = (ArmorItem)armorForBone.m_41720_();
                HumanoidModel armorModel = (HumanoidModel)ForgeHooksClient.getArmorModel(this.currentEntityBeingRendered, (ItemStack)armorForBone, (EquipmentSlot)boneSlot, boneSlot == EquipmentSlot.LEGS ? this.DEFAULT_BIPED_ARMOR_MODEL_INNER : this.DEFAULT_BIPED_ARMOR_MODEL_OUTER);
                if (armorModel != null) {
                    ModelPart sourceLimb = this.getArmorPartForBone(bone.getName(), armorModel);
                    List cubeList = sourceLimb.f_104212_;
                    if (sourceLimb != null && cubeList != null && !cubeList.isEmpty()) {
                        this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack);
                        stack.m_85841_(-1.0f, -1.0f, 1.0f);
                        stack.m_85836_();
                        ResourceLocation armorResource = this.getArmorResource((Entity)this.currentEntityBeingRendered, armorForBone, boneSlot, null);
                        this.renderArmorOfItem(armorItem, armorForBone, boneSlot, armorResource, sourceLimb, stack, packedLightIn, packedOverlayIn);
                        stack.m_85849_();
                        bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                    }
                }
            } else if (armorForBone.m_41720_() instanceof GeoArmorItem) {
                List cubeList;
                ModelPart sourceLimb;
                GeoArmorItem armorItem = (GeoArmorItem)armorForBone.m_41720_();
                GeoArmorRenderer geoArmorRenderer = GeoArmorRenderer.getRenderer(((Object)((Object)armorItem)).getClass(), this.currentEntityBeingRendered);
                GeoArmorRenderer armorModel = geoArmorRenderer;
                if (armorModel != null && (sourceLimb = this.getArmorPartForBone(bone.getName(), armorModel)) != null && (cubeList = sourceLimb.f_104212_) != null && !cubeList.isEmpty()) {
                    stack.m_85841_(-1.0f, -1.0f, 1.0f);
                    stack.m_85836_();
                    this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, true, boneSlot == EquipmentSlot.CHEST);
                    geoArmorRenderer.setCurrentItem((LivingEntity)this.currentEntityBeingRendered, armorForBone, boneSlot);
                    geoArmorRenderer.applySlot(boneSlot);
                    this.handleGeoArmorBoneVisibility(geoArmorRenderer, sourceLimb, armorModel, boneSlot);
                    VertexConsumer ivb = ItemRenderer.m_115184_((MultiBufferSource)this.rtb, (RenderType)RenderType.m_110431_((ResourceLocation)GeoArmorRenderer.getRenderer(((Object)((Object)armorItem)).getClass(), this.currentEntityBeingRendered).getTextureLocation(armorItem)), (boolean)false, (boolean)armorForBone.m_41790_());
                    geoArmorRenderer.render(this.currentPartialTicks, stack, ivb, packedLightIn);
                    stack.m_85849_();
                    bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                }
            } else if (armorForBone.m_41720_() instanceof BlockItem && ((BlockItem)armorForBone.m_41720_()).m_40614_() instanceof AbstractSkullBlock) {
                this.HEAD_QUEUE.add((Tuple<GeoBone, ItemStack>)new Tuple((Object)bone, (Object)armorForBone));
            }
        }
    }

    protected void handleGeoArmorBoneVisibility(GeoArmorRenderer<? extends GeoArmorItem> geoArmorRenderer, ModelPart sourceLimb, HumanoidModel<?> armorModel, EquipmentSlot slot) {
        IBone gbHead = geoArmorRenderer.getAndHideBone(geoArmorRenderer.headBone);
        IBone gbBody = geoArmorRenderer.getAndHideBone(geoArmorRenderer.bodyBone);
        IBone gbArmL = geoArmorRenderer.getAndHideBone(geoArmorRenderer.leftArmBone);
        IBone gbArmR = geoArmorRenderer.getAndHideBone(geoArmorRenderer.rightArmBone);
        IBone gbLegL = geoArmorRenderer.getAndHideBone(geoArmorRenderer.leftLegBone);
        IBone gbLegR = geoArmorRenderer.getAndHideBone(geoArmorRenderer.rightLegBone);
        IBone gbBootL = geoArmorRenderer.getAndHideBone(geoArmorRenderer.leftBootBone);
        IBone gbBootR = geoArmorRenderer.getAndHideBone(geoArmorRenderer.rightBootBone);
        if (sourceLimb == armorModel.f_102808_ || sourceLimb == armorModel.f_102809_) {
            gbHead.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102810_) {
            gbBody.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102812_) {
            gbArmL.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102814_) {
            if (slot == EquipmentSlot.FEET) {
                gbBootL.setHidden(false);
            } else {
                gbLegL.setHidden(false);
            }
            return;
        }
        if (sourceLimb == armorModel.f_102811_) {
            gbArmR.setHidden(false);
            return;
        }
        if (sourceLimb == armorModel.f_102813_) {
            if (slot == EquipmentSlot.FEET) {
                gbBootR.setHidden(false);
            } else {
                gbLegR.setHidden(false);
            }
            return;
        }
    }

    protected void renderArmorOfItem(ArmorItem armorItem, ItemStack armorForBone, EquipmentSlot boneSlot, ResourceLocation armorResource, ModelPart sourceLimb, PoseStack stack, int packedLightIn, int packedOverlayIn) {
        if (armorItem instanceof DyeableArmorItem) {
            int i = ((DyeableArmorItem)armorItem).m_41121_(armorForBone);
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, r, g, b, 1.0f, armorForBone, armorResource);
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, this.getArmorResource((Entity)this.currentEntityBeingRendered, armorForBone, boneSlot, "overlay"));
        } else {
            this.renderArmorPart(stack, sourceLimb, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f, armorForBone, armorResource);
        }
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack) {
        this.prepareArmorPositionAndScale(bone, cubeList, sourceLimb, stack, false, false);
    }

    protected void prepareArmorPositionAndScale(GeoBone bone, List<ModelPart.Cube> cubeList, ModelPart sourceLimb, PoseStack stack, boolean geoArmor, boolean modMatrixRot) {
        GeoCube firstCube = bone.childCubes.get(0);
        ModelPart.Cube armorCube = cubeList.get(0);
        float targetSizeX = firstCube.size.m_122239_();
        float targetSizeY = firstCube.size.m_122260_();
        float targetSizeZ = firstCube.size.m_122269_();
        float sourceSizeX = Math.abs(armorCube.f_104338_ - armorCube.f_104335_);
        float sourceSizeY = Math.abs(armorCube.f_104339_ - armorCube.f_104336_);
        float sourceSizeZ = Math.abs(armorCube.f_104340_ - armorCube.f_104337_);
        float scaleX = targetSizeX / sourceSizeX;
        float scaleY = targetSizeY / sourceSizeY;
        float scaleZ = targetSizeZ / sourceSizeZ;
        sourceLimb.m_104227_(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        if (!geoArmor) {
            sourceLimb.f_104203_ = -bone.getRotationX();
            sourceLimb.f_104204_ = -bone.getRotationY();
            sourceLimb.f_104205_ = bone.getRotationZ();
        } else {
            float xRot = -bone.getRotationX();
            xRot *= 2.0f;
            float yRot = -bone.getRotationY();
            yRot *= 2.0f;
            float zRot = bone.getRotationZ();
            zRot *= 2.0f;
            GeoBone tmpBone = bone.parent;
            while (tmpBone != null) {
                xRot -= tmpBone.getRotationX();
                yRot -= tmpBone.getRotationY();
                zRot += tmpBone.getRotationZ();
                tmpBone = tmpBone.parent;
            }
            if (modMatrixRot) {
                xRot = (float)Math.toRadians(xRot);
                yRot = (float)Math.toRadians(yRot);
                zRot = (float)Math.toRadians(zRot);
                stack.m_85845_(new Quaternion(0.0f, 0.0f, zRot, false));
                stack.m_85845_(new Quaternion(0.0f, yRot, 0.0f, false));
                stack.m_85845_(new Quaternion(xRot, 0.0f, 0.0f, false));
            } else {
                sourceLimb.f_104203_ = xRot;
                sourceLimb.f_104204_ = yRot;
                sourceLimb.f_104205_ = zRot;
            }
        }
        stack.m_85841_(scaleX, scaleY, scaleZ);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.getCurrentRTB() == null) {
            throw new IllegalStateException("RenderTypeBuffer must never be null at this point!");
        }
        if (this.getCurrentModelRenderCycle() != EModelRenderCycle.INITIAL) {
            super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            return;
        }
        this.textureForBone = this.getCurrentModelRenderCycle() != EModelRenderCycle.INITIAL ? null : this.getTextureForBone(bone.getName(), this.currentEntityBeingRendered);
        boolean customTextureMarker = this.textureForBone != null;
        ResourceLocation currentTexture = this.getTextureLocation(this.currentEntityBeingRendered);
        RenderType rt = customTextureMarker ? this.getRenderTypeForBone(bone, this.currentEntityBeingRendered, this.currentPartialTicks, stack, bufferIn, this.getCurrentRTB(), packedLightIn, this.textureForBone) : this.getRenderType(this.currentEntityBeingRendered, this.currentPartialTicks, stack, this.getCurrentRTB(), bufferIn, packedLightIn, currentTexture);
        bufferIn = this.getCurrentRTB().m_6299_(rt);
        if (this.getCurrentModelRenderCycle() == EModelRenderCycle.INITIAL) {
            stack.m_85836_();
            if (this.isArmorBone(bone)) {
                stack.m_85836_();
                this.handleArmorRenderingForBone(bone, stack, bufferIn, packedLightIn, packedOverlayIn, currentTexture);
                stack.m_85849_();
                bufferIn = this.getCurrentRTB().m_6299_(rt);
            } else {
                ItemStack boneItem = this.getHeldItemForBone(bone.getName(), this.currentEntityBeingRendered);
                BlockState boneBlock = this.getHeldBlockForBone(bone.getName(), this.currentEntityBeingRendered);
                if (boneItem != null || boneBlock != null) {
                    stack.m_85836_();
                    this.handleItemAndBlockBoneRendering(stack, bone, boneItem, boneBlock, packedLightIn, packedOverlayIn);
                    stack.m_85849_();
                    bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)currentTexture));
                }
            }
            stack.m_85849_();
        }
        this.customBoneSpecificRenderingHook(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, customTextureMarker, currentTexture);
        stack.m_85836_();
        super.preparePositionRotationScale(bone, stack);
        super.renderCubesOfBone(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (customTextureMarker) {
            bufferIn = this.getCurrentRTB().m_6299_(this.getRenderType(this.currentEntityBeingRendered, this.currentPartialTicks, stack, this.rtb, bufferIn, packedLightIn, currentTexture));
            this.textureForBone = null;
        }
        super.renderChildBones(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        stack.m_85849_();
    }

    protected void customBoneSpecificRenderingHook(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean customTextureMarker, ResourceLocation currentTexture) {
    }

    protected void handleItemAndBlockBoneRendering(PoseStack stack, GeoBone bone, @Nullable ItemStack boneItem, @Nullable BlockState boneBlock, int packedLightIn, int packedOverlayIn) {
        RenderUtils.translate(bone, stack);
        RenderUtils.moveToPivot(bone, stack);
        RenderUtils.rotate(bone, stack);
        RenderUtils.scale(bone, stack);
        RenderUtils.moveBackFromPivot(bone, stack);
        this.moveAndRotateMatrixToMatchBone(stack, bone);
        if (boneItem != null) {
            this.preRenderItem(stack, boneItem, bone.getName(), this.currentEntityBeingRendered, bone);
            this.renderItemStack(stack, this.getCurrentRTB(), packedLightIn, boneItem, bone.getName());
            this.postRenderItem(stack, boneItem, bone.getName(), this.currentEntityBeingRendered, bone);
        }
        if (boneBlock != null) {
            this.preRenderBlock(stack, boneBlock, bone.getName(), this.currentEntityBeingRendered);
            this.renderBlock(stack, this.getCurrentRTB(), packedLightIn, boneBlock);
            this.postRenderBlock(stack, boneBlock, bone.getName(), this.currentEntityBeingRendered);
        }
    }

    protected void renderItemStack(PoseStack stack, MultiBufferSource rtb, int packedLightIn, ItemStack boneItem, String boneName) {
        Minecraft.m_91087_().m_91291_().m_174242_(this.currentEntityBeingRendered, boneItem, this.getCameraTransformForItemAtBone(boneItem, boneName), false, stack, rtb, null, packedLightIn, LivingEntityRenderer.m_115338_(this.currentEntityBeingRendered, (float)0.0f), this.currentEntityBeingRendered.m_142049_());
    }

    protected RenderType getRenderTypeForBone(GeoBone bone, T currentEntityBeingRendered2, float currentPartialTicks2, PoseStack stack, VertexConsumer bufferIn, MultiBufferSource currentRenderTypeBufferInUse2, int packedLightIn, ResourceLocation currentTexture) {
        return this.getRenderType(currentEntityBeingRendered2, currentPartialTicks2, stack, currentRenderTypeBufferInUse2, bufferIn, packedLightIn, currentTexture);
    }

    protected void renderArmorPart(PoseStack stack, ModelPart sourceLimb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, ItemStack armorForBone, ResourceLocation armorResource) {
        VertexConsumer ivb = ItemRenderer.m_115184_((MultiBufferSource)this.rtb, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)armorForBone.m_41790_());
        sourceLimb.m_104306_(stack, ivb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Nullable
    protected abstract ResourceLocation getTextureForBone(String var1, T var2);

    protected void renderBlock(PoseStack matrixStack, MultiBufferSource rtb, int packedLightIn, BlockState iBlockState) {
        if (iBlockState.m_60799_() != RenderShape.MODEL) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.25, -0.25, -0.25);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91289_().m_110912_(iBlockState, matrixStack, rtb, packedLightIn, OverlayTexture.f_118083_);
        matrixStack.m_85849_();
    }

    @Nullable
    protected abstract ItemStack getHeldItemForBone(String var1, T var2);

    protected abstract ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack var1, String var2);

    @Nullable
    protected abstract BlockState getHeldBlockForBone(String var1, T var2);

    protected abstract void preRenderItem(PoseStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void preRenderBlock(PoseStack var1, BlockState var2, String var3, T var4);

    protected abstract void postRenderItem(PoseStack var1, ItemStack var2, String var3, T var4, IBone var5);

    protected abstract void postRenderBlock(PoseStack var1, BlockState var2, String var3, T var4);

    @Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        return null;
    }

    @Nullable
    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        return null;
    }

    @Nullable
    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        return null;
    }

    protected ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    @Override
    public void createVerticesOfQuad(GeoQuad quad, Matrix4f matrix4f, Vector3f normal, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.textureForBone == null) {
            super.createVerticesOfQuad(quad, matrix4f, normal, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        Tuple<Integer, Integer> tfbSize = this.getOrCreateTextureSize(this.textureForBone);
        Tuple<Integer, Integer> textureSize = this.getOrCreateTextureSize(this.getTextureLocation(this.currentEntityBeingRendered));
        if (tfbSize == null || textureSize == null) {
            super.createVerticesOfQuad(quad, matrix4f, normal, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            return;
        }
        for (GeoVertex vertex : quad.vertices) {
            Vector4f vector4f = new Vector4f(vertex.position.m_122239_(), vertex.position.m_122260_(), vertex.position.m_122269_(), 1.0f);
            vector4f.m_123607_(matrix4f);
            float texU = vertex.textureU * (float)((Integer)textureSize.m_14418_()).intValue() / (float)((Integer)tfbSize.m_14418_()).intValue();
            float texV = vertex.textureV * (float)((Integer)textureSize.m_14419_()).intValue() / (float)((Integer)tfbSize.m_14419_()).intValue();
            bufferIn.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, texU, texV, packedOverlayIn, packedLightIn, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        }
    }

    protected Tuple<Integer, Integer> getOrCreateTextureSize(ResourceLocation tex) {
        if (TEXTURE_SIZE_CACHE.containsKey(tex)) {
            return TEXTURE_SIZE_CACHE.get(tex);
        }
        Tuple<Integer, Integer> size = this.getSizeOfTexture(tex);
        if (size == null) {
            return null;
        }
        return TEXTURE_SIZE_CACHE.computeIfAbsent(tex, rs -> size);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Tuple<Integer, Integer> getSizeOfTexture(ResourceLocation tex) {
        if (tex == null) {
            return null;
        }
        AbstractTexture originalTexture = null;
        Minecraft mc = Minecraft.m_91087_();
        TextureManager textureManager = mc.m_91097_();
        try {
            originalTexture = (AbstractTexture)mc.m_18691_(() -> {
                AbstractTexture texture = textureManager.m_118506_(tex);
                if (texture == null) {
                    return null;
                }
                return texture;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            GeckoLib.LOGGER.warn("Failed to load image for id {}", (Object)tex);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            GeckoLib.LOGGER.warn("Found no image file for id {}", (Object)tex);
            return null;
        }
        try (Resource res = mc.m_91098_().m_142591_(tex);){
            if (res == null) return null;
            NativeImage image = originalTexture instanceof DynamicTexture ? ((DynamicTexture)originalTexture).m_117991_() : NativeImage.m_85058_((InputStream)res.m_6679_());
            if (image == null) return null;
            Tuple tuple = new Tuple((Object)image.m_84982_(), (Object)image.m_85084_());
            return tuple;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

